#include <xtl.h>
#include "xboxtools.h"

// some function pointers
void (*XamLoaderLaunchTitle)(const char *, u32); // not really needed, just use xlaunchnewimage

//XamContentOpenFile(userflagmask,mntdev,imgpath, perm? ,? ,? , xoverlapped)
#define XAMCONTENTOPENFILE_ORD (u32)0x269
u32 (*XamContentOpenFile)(u32, char*, char*,u32,u32,u32,u32*);//last 3 u32 are things like xoverlapped ptrs

// XamContentClose(pathtooriginalmapping,xoverlapped)
#define XAMCONTENTCLOSE_ORD (u32)0x25a
u32 (*XamContentClose)(char*,u32*);


u32 resolveFunct(char* modname, u32 ord)
{
   UINT32 ptr32=0, ret=0, ptr2=0;
   ret = XexGetModuleHandle(modname, &ptr32); //xboxkrnl.exe xam.dll?
   //console.Format("%s - XexGetModuleHandle ret: %08x, ptr32: %08x\n", modname, ret, ptr32);
   if(ret == 0)
   {
      ret = XexGetProcedureAddress(ptr32, ord, &ptr2 );
      //console.Format("%s - XexGetProcedureAddress ret: %08x, ptr2: %08x\n", modname, ret, ptr2);
      if(ptr2 != 0)
         return ptr2;
   }
   return 0; // function not found
}
/*
int GetGamerXUID(int playerIndex,PXUID ret)
{
	DWORD dwErr = XUserGetXUID(playerIndex,ret);
	
	return dwErr;
}*/
long GetGamerPoints(int playerIndex)
{
	if(IsUserSignedIn(playerIndex))
	{
	DWORD requestedSettings[1] ={XPROFILE_GAMERCARD_CRED};
	 
	DWORD cbResults = 0;
	

	// The first call to XUserReadProfileSettings determines the size of the
	// buffer that will be needed to hold the profile information.
	DWORD dwErr = XUserReadProfileSettings(
		0,            // The title ID. Zero for the current title.
		playerIndex,            // The User Index. Zero for the first user.
		1, // The number of settings in the array.
		requestedSettings, // The array of settings to retrieve.
		&cbResults,   // The size (in bytes) of the space needed to retrieve settings.
		0,            // Pointer to results buffer. Set to NULL to retrieve the size needed.
		0);           // Pointer to XOVERLAPPED, or NULL to work synchronously.

	
	// Allocate the buffer using the size returned by the first call to
	// XUserReadProfileSettings.
	XUSER_READ_PROFILE_SETTING_RESULT* pResults =
    (XUSER_READ_PROFILE_SETTING_RESULT*)(new BYTE[cbResults]);

	// Call XUserReadProfileSettings again, using the allocated buffer instead
	// of NULL.
	dwErr = XUserReadProfileSettings(
		0, playerIndex, 1, requestedSettings, &cbResults,
		pResults, // This argument now holds the allocated buffer.
		0);
    XUSER_PROFILE_SETTING* pSrc = pResults->pSettings;
	
	return pSrc->data.nData;
	}
	else
	{
		return 0;
	}
//	_ultoa( pResults[0].pSettings->data.nData, ret, 10 );
//	sprintf_s( ret,100, "%d", pSetting->data.nData  );
              
	//_ultow_s(&pResults->pSettings->data.nData,ret,10);




}

bool SaveTextureToPNGFile(IDirect3DTexture9* pTexture, string pLocation)
{
	/*LPD3DXBUFFER buf;
	FILE *file;
	HRESULT hr = D3DXSaveTextureToFileInMemory(&buf,D3DXIFF_PNG,pTexture,NULL);
	fopen_s(&file,pLocation.c_str(), "wb");
	fwrite((VOID*)buf->GetBufferPointer(), buf->GetBufferSize(), 1, file);
	fclose(file);*/
	HRESULT hr = D3DXSaveTextureToFileA(pLocation.c_str(),D3DXIFF_PNG,pTexture,NULL);
	return hr ==D3D_OK;
}

int GetGamerPicture(int playerIndex,PBYTE ret,BOOL small,DWORD pitch,DWORD height)
{
if(IsUserSignedIn(playerIndex))
	{
	DWORD dwErr = XUserReadGamerPicture(playerIndex,small,ret,pitch,height,NULL);
	
	return dwErr;
}
else
{
	return 0;
}
}
bool IsUserSignedIn(int playerIndex)
{
	  XUSER_SIGNIN_STATE State = XUserGetSigninState( playerIndex );
		if( State != eXUserSigninState_NotSignedIn )
        {
			return true;
		}
		else
		{
			return false;
		}
}
int GetGamerTag(int playerIndex,char *ret)
{
	if(IsUserSignedIn(playerIndex))
	{
	DWORD dwErr = XUserGetName(playerIndex,ret,100);
	
	return dwErr;
	}
	else
	{
		return 0;
	}
/*	LPSTR szUserName;
	
	return 0;*/
}
/* MATTIE: replaced by XeDebug
void DebugMsg(const char *format, ...) 
{
	char debugbuf[4096];

	va_list ap;
	va_start (ap, format);
	vsprintf_s(debugbuf,4096, format, ap);
	va_end (ap);

	debugLog(debugbuf);
}
*/

void FTPMsg(const char *format, ...) 
{
	char debugbuf[4096];

	va_list ap;
	va_start (ap, format);
	vsprintf_s(debugbuf,4096, format, ap);
	va_end (ap);

	ftpLog(debugbuf);
}


void debugLog(const char* output)
{
    ofstream writeLog;

    writeLog.open("game:\\debug.log",ofstream::app);
    if (writeLog.is_open())
    {
      writeLog.write(output,strlen(output));
      writeLog.write("\n",1);
    }
    writeLog.close();
}

void ftpLog(const char* output)
{
    ofstream writeLog;

    writeLog.open("game:\\ftp.log",ofstream::app);
    if (writeLog.is_open())
    {
      writeLog.write(output,strlen(output));
      writeLog.write("\n",1);
    }
    writeLog.close();
}

HRESULT Mount( int Device, char* MountPoint )
{
	char MountConv[260];
	sprintf_s( MountConv,"\\??\\%s", MountPoint );

	char * SysPath = NULL;
	switch( Device )
	{
		case DEVICE_NAND_FLASH:
			SysPath = "\\Device\\Flash";
			break;
		case DEVICE_MEMORY_UNIT0:
			SysPath = "\\Device\\Mu0";
			break;
		case DEVICE_MEMORY_UNIT1:
			SysPath = "\\Device\\Mu1";
			break;
		case DEVICE_MEMORY_ONBOARD:
			SysPath = "\\Device\\BuiltInMuSfc";
			break;
		case DEVICE_CDROM0:
			SysPath = "\\Device\\Cdrom0";
			break;
		case DEVICE_HARDISK0_PART1:
			SysPath = "\\Device\\Harddisk0\\Partition1";
			break;
		case DEVICE_HARDISK0_SYSPART:
			SysPath = "\\Device\\Harddisk0\\SystemPartition";
			break;
		case DEVICE_USB0:
			SysPath = "\\Device\\Mass0";
			break;
		case DEVICE_USB1:
			SysPath = "\\Device\\Mass1";
			break;
		case DEVICE_USB2:
			SysPath = "\\Device\\Mass2";
			break;
//		case DEVICE_TEST:
//			SysPath = "\\Device\\";
//			break;
	}

	STRING sSysPath = { (USHORT)strlen( SysPath ), (USHORT)strlen( SysPath ) + 1, SysPath };
	STRING sMountConv = { (USHORT)strlen( MountConv ), (USHORT)strlen( MountConv ) + 1, MountConv };
	int res = ObCreateSymbolicLink( &sMountConv, &sSysPath );

	if (res != 0)
		return res;

	return DriveMounted(MountPoint);
}

int DriveMounted(string path)
{
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	string searchcmd = path + "\\*.*";
	//debugLog(searchcmd.c_str());
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return 0;
	}
	FindClose(hFind);

	return 1;
}

HRESULT Unmount( char* MountPoint )
{
	char MountConv[16];
	sprintf_s( MountConv,"\\??\\%s", MountPoint );

	STRING sMountConv = { (USHORT)strlen(MountConv), (USHORT)strlen(MountConv) + 1, MountConv };
	return ( HRESULT )  ObDeleteSymbolicLink( &sMountConv );
}

// returns 0 on success, creates symbolic link on it's own to the new szDrive
u32 mountCon(CHAR* szDrive, CHAR* szDevice, CHAR* szPath)
{
   u32 ret;
   CHAR szMountPath[MAX_PATH];
   if(XamContentOpenFile == 0)
   {
      ret = resolveFunct("xam.xex", XAMCONTENTOPENFILE_ORD);
      XamContentOpenFile = (u32 (__cdecl *)(u32, char*, char*,u32,u32,u32,u32*))ret;
      if(XamContentOpenFile == 0)
         return ERROR_INVALID_HANDLE; // well, invalid handle good enough for me...
   }
   sprintf_s(szMountPath,MAX_PATH,"\\??\\%s\\%s",szDevice,szPath);
   return XamContentOpenFile(0xFE, szDrive, szMountPath, 0x4000003,0,0,0);
}

// returns 0 on success, destorys symbolic link as well
u32 unmountCon(CHAR* szDrive, CHAR* szDevice, CHAR* szPath)
{
//   USHORT len;
   u32 ret;
   CHAR szMountPath[MAX_PATH];
   if(XamContentClose == 0) // make sure the funciton is resolved
   {
      ret = resolveFunct("xam.xex", XAMCONTENTCLOSE_ORD);
      //console.Format("resolver returns %08x\n", ret);
      //console.Format("ContentClose before: %08x\n", XamContentClose);
      XamContentClose = (u32 (__cdecl *)(char *,u32 *))ret;
      //console.Format("ContentOpen after: %08x\n", XamContentClose);
      if(XamContentClose == 0)
         return ERROR_INVALID_HANDLE;
   }
   sprintf_s(szMountPath,MAX_PATH,"\\??\\%s",szDrive);
   //console.Format("umt path: %s\n", szMountPath);
   return  XamContentClose(szMountPath,0);
}

bool InitNetwork()
{
	DWORD dwStatus = XNetGetEthernetLinkStatus();

	int m_bIsOnline = ( dwStatus & XNET_ETHERNET_LINK_ACTIVE ) != 0;

	if( !m_bIsOnline )
	{
		printf("NO ETHERNET LINK ACTIVE\n");
		return false;
	}

	XNetStartupParams xnsp;
	memset(&xnsp, 0, sizeof(xnsp));
	xnsp.cfgSizeOfStruct = sizeof(XNetStartupParams);
	xnsp.cfgFlags = XNET_STARTUP_BYPASS_SECURITY;




xnsp.cfgSockDefaultRecvBufsizeInK = 128; // default = 16 
xnsp.cfgSockDefaultSendBufsizeInK = 128; // default = 16 

	INT iResult = XNetStartup( &xnsp );

	if( iResult != NO_ERROR )
	{
		debugLog("XNETSTARTUP ERROR");
		return false;
	}

	WSADATA WsaData;
	iResult = WSAStartup( MAKEWORD( 2, 2 ), &WsaData );
	if( iResult != NO_ERROR )
	{
		debugLog("WSASTARTUP ERROR");
		return false;
	}

	debugLog("Network initialized");
	return true;
}
